<?php
use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;
use Automattic\WooCommerce\StoreApi\Payments\PaymentContext;
use Automattic\WooCommerce\StoreApi\Payments\PaymentResult;

/**
 * Flow Blocks integration
 *
 * @since 1.0.3
 */
final class WC_Gateway_Flow_Blocks_Support extends AbstractPaymentMethodType {

	/**
	 * The gateway instance.
	 *
	 * @var WC_Flow_Gateway
	 */
	private $gateway;

	/**
	 * Payment method name/id/slug.
	 *
	 * @var string
	 */
	protected $name = 'flowpayment';

	/**
	 * Initializes the payment method type.
	 */
	public function initialize() {
		$this->settings = get_option( 'woocommerce_flowpayment_settings', [] );
		$gateways       = WC()->payment_gateways->payment_gateways();
		$this->gateway  = $gateways[ $this->name ];
	}

	/**
	 * Returns if this payment method should be active. If false, the scripts will not be enqueued.
	 *
	 * @return boolean
	 */
	public function is_active() {
		return $this->gateway->is_available();
	}

	/**
	 * Returns an array of scripts/handles to be registered for this payment method.
	 *
	 * @return array
	 */
	public function get_payment_method_script_handles() {
		$script_path       = '/assets/js/frontend/blocks.js';
		$script_asset_path = WC_Flow_Payments::plugin_abspath() . 'assets/js/frontend/blocks.asset.php';
		$script_asset      = file_exists( $script_asset_path )
			? require( $script_asset_path )
			: array(
				'dependencies' => array(),
				'version'      => '1.4.0'
			);
		$script_url        = WC_Flow_Payments::plugin_url() . $script_path;

		wp_register_script(
			'wc-flowpayment-blocks',
			$script_url,
			$script_asset[ 'dependencies' ],
			$script_asset[ 'version' ],
			true
		);

		if ( function_exists( 'wp_set_script_translations' ) ) {
			wp_set_script_translations( 'wc-flowpayment-blocks', 'woocommerce-gateway-flowpayment', );
		}

		return [ 'wc-flowpayment-blocks' ];
	}

	/**
	 * Returns an array of key=>value pairs of data made available to the payment methods script.
	 *
	 * @return array
	 */
	public function get_payment_method_data() {
		if (file_exists(PLUGIN_DIR . "images/logo-small.png")) {
            if (!file_exists(PLUGIN_DIR . "images/custom-logo-small.png")) {
                copy(PLUGIN_DIR . "images/logo-small.png", PLUGIN_DIR . "images/custom-logo-small.png");
            }
        }
        //$this->icon = plugins_url('images/custom-logo-small.png', PLUGIN_DIR);
		return [
			'title'       => $this->get_setting( 'title' ),
			'description' => $this->get_setting( 'description' ),
			'logo_url'    => WC_GATEWAY_FLOWPAYMENT_URL . '/images/custom-logo-small.png',
		];
	}
}
