
import React, { Fragment } from '@wordpress/element';
import { sprintf, __ } from '@wordpress/i18n';
import { registerPaymentMethod } from '@woocommerce/blocks-registry';
import { decodeEntities } from '@wordpress/html-entities';
import { getSetting } from '@woocommerce/settings';
import { PAYMENT_METHOD_NAME } from './constants';

const settings = getSetting( 'flowpayment_data', {} );

const defaultLabel = __(
	'Flow Payment',
	'woocommerce-gateway-flowpayment'
);

const label = decodeEntities( settings.title ) || defaultLabel;
/**
 * Content component
 */
const Content = () => {
	return decodeEntities( settings.description || '' );
};
/**
 * Label component
 *
 * @param {*} props Props from payment API.
 */
const Label = ( props ) => {
	const { PaymentMethodLabel } = props.components;
	const logoUrl = settings.logo_url;

    return (
        <Fragment>
            {logoUrl && <img src={logoUrl} alt="Logo" style={{ marginRight: '10px' }} />} 
            <PaymentMethodLabel text={label} />
        </Fragment>
    );
};

/**
 * Flow payment method config object add logo
 */

const Flowpayment_Gateway = {
	name: PAYMENT_METHOD_NAME,
	label: <Label />,
	content: <Content />,
	edit: <Content />,
	canMakePayment: () => true,
	ariaLabel: label
};

registerPaymentMethod( Flowpayment_Gateway );
